/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.console;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HSCVPD;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcmd.cimom.CIMServer;

public class OmConsoleUpdater {
    private ProviderCIMOMHandle mProvCimomHandle = null;
    private OmConsoleMgr mConsoleMgr = null;
    private HSCVPD mVpd = null;

    OmConsoleUpdater(OmConsoleMgr omConsoleMgr) {
        this.mConsoleMgr = omConsoleMgr;
    }

    void createConsoleInst() throws CIMException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Console", "root/ibmhscS1_0");
            this.mConsoleMgr.getCimServer();
            this.mProvCimomHandle = (ProviderCIMOMHandle)CIMServer.getCIMOMHandle((CIMObjectPath)cIMObjectPath);
            CIMClass cIMClass = this.mProvCimomHandle.getClass(cIMObjectPath, false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            this.mVpd = new HSCVPD();
            String string = this.mConsoleMgr.getHmcId();
            System.out.println("consoleName: " + string);
            Vector vector = new Vector();
            cIMInstance.setProperty("Name", new CIMValue((Object)string));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            System.out.println("before set HmcVersion");
            cIMInstance.setProperty("HMCVersion", new CIMValue((Object)this.getHmcVersion()));
            System.out.println("ci = " + cIMInstance);
            System.out.println("getHmcVersion = " + this.getHmcVersion());
            cIMObjectPath.setKeys(cIMInstance.getKeyValuePairs());
            System.out.println("bef create console inst op " + cIMObjectPath);
            System.out.println("bef create console inst ci " + cIMInstance);
            CIMObjectPath cIMObjectPath2 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath, cIMInstance);
            UnsignedInt64 unsignedInt64 = OmConsoleMgr.HmcConcMaintCaps;
            cIMInstance.setProperty("IOConcurrentCap", new CIMValue((Object)unsignedInt64));
            cIMInstance.setProperty("VPD", new CIMValue((Object)this.getVpdStr(string, cIMObjectPath2)));
            CimomWrapper.setInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            return;
        }
    }

    private String getVpdStr(String string, CIMObjectPath cIMObjectPath) throws CIMException, UnknownHostException {
        String string2 = "*FC ????????\n*DS Hardware Management Console\n";
        string2 = this.createChassisInst(cIMObjectPath, string2);
        string2 = this.createMotherBoardInst(cIMObjectPath, string2);
        string2 = this.createMemInst(string, cIMObjectPath, string2);
        string2 = this._createOSInst(string, cIMObjectPath, string2);
        InetAddress inetAddress = InetAddress.getLocalHost();
        System.out.println("host: " + inetAddress);
        string2 = this.createNetworkSettingInst(string, cIMObjectPath, inetAddress, string2);
        this.createLparManagementInst(string, cIMObjectPath);
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>> VPD = " + string2);
        return string2;
    }

    private String createMotherBoardInst(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        try {
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_Card", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = string;
            String string3 = null;
            if (!this.mVpd.isVPDPresent()) {
                throw new HSCCIMException("1781");
            }
            string3 = this.mVpd.getHSCMotherboard();
            string2 = string2.concat("*PN ");
            string2 = string2.concat(string3);
            string2 = string2.concat("\n");
            cIMInstance.setProperty("CreationClassname", new CIMValue((Object)"CIM_Card"));
            cIMInstance.setProperty("Tag", new CIMValue((Object)string3));
            cIMInstance.setProperty("SerialNumber", new CIMValue((Object)string3));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("CIM_Card", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_ComputerSystemPackage", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("Dependent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath3));
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("CIM_ComputerSystemPackage", "root/ibmhscS1_0");
            cIMObjectPath4.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath4, cIMInstance2);
            return string2;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("1779");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private String createChassisInst(CIMObjectPath cIMObjectPath, String string) throws CIMException {
        try {
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_Chassis", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string2 = string;
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"CIM_Chassis"));
            String string3 = null;
            String string4 = null;
            String string5 = null;
            if (!this.mVpd.isVPDPresent()) {
                throw new HSCCIMException("1781");
            }
            string3 = this.mVpd.getHSCModel();
            string4 = this.mVpd.getHSCSerialNumber();
            string5 = this.mVpd.getHSCProductName();
            String string6 = string3;
            string6 = string3.indexOf(45) != -1 ? string3 : (string3.length() < 4 ? string3 : string3.substring(0, 4) + "-" + string3.substring(4));
            string2 = string2.concat("*TM ");
            string2 = string2.concat(string6);
            string2 = string2.concat("\n");
            string2 = string2.concat("*SE ");
            string2 = string2.concat(string4);
            string2 = string2.concat("\n");
            string2 = string2.concat("*MN IBM");
            string2 = string2.concat("\n");
            string6 = string3.concat("*").concat(string4);
            cIMInstance.setProperty("Tag", new CIMValue((Object)string6));
            cIMInstance.setProperty("Manufacturer", new CIMValue((Object)"IBM"));
            cIMInstance.setProperty("Model", new CIMValue((Object)string3));
            cIMInstance.setProperty("SerialNumber", new CIMValue((Object)string4));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("CIM_Chassis", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_ComputerSystemPackage", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("Dependent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath3));
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("CIM_ComputerSystemPackage", "root/ibmhscS1_0");
            cIMObjectPath4.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath4, cIMInstance2);
            return string2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("177A");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private String createNetworkSettingInst(String string, CIMObjectPath cIMObjectPath, InetAddress inetAddress, String string2) throws CIMException {
        try {
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_NetworkSetting", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string3 = string2;
            string3 = string3.concat("*NA ");
            string3 = string3.concat(inetAddress.getHostAddress());
            string3 = string3.concat("\n");
            cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)string));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)"ClientNetwork"));
            cIMInstance.setProperty("Hostname", new CIMValue((Object)inetAddress.getHostName()));
            cIMInstance.setProperty("IPAddress", new CIMValue((Object)inetAddress.getHostAddress()));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_NetworkSetting"));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_NetworkSetting", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_SystemNetworkSetting", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("Element", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath3));
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_SystemNetworkSetting", "root/ibmhscS1_0");
            cIMObjectPath4.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath4, cIMInstance2);
            return string3;
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("177B");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private void createLparManagementInst(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_LparManagement", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_LparManagement"));
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)string));
            cIMInstance.setProperty("Name", new CIMValue((Object)"LparManagement"));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparManagement", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_ConsoleHostedService", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("Antecedent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Dependent", new CIMValue((Object)cIMObjectPath3));
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_ConsoleHostedService", "root/ibmhscS1_0");
            cIMObjectPath4.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath4, cIMInstance2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("177C");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private String _createOSInst(String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        try {
            Vector vector;
            CIMValue cIMValue;
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_OperatingSystem", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string3 = string2;
            string3 = string3.concat("*OS ");
            string3 = string3.concat("Embedded Operating Systems");
            string3 = string3.concat("\n");
            CIMProperty cIMProperty = cIMClass.getProperty("OSType");
            CIMQualifier cIMQualifier = cIMProperty.getQualifier("Values");
            int n = -1;
            if (cIMQualifier != null && (cIMValue = cIMQualifier.getValue()) != null) {
                vector = (Vector)cIMValue.getValue();
                n = vector.indexOf(new CIMValue((Object)"Embedded Operating Systems"));
            }
            cIMInstance.setProperty("CSCreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"CIM_OperatingSystem"));
            cIMInstance.setProperty("CSName", new CIMValue((Object)string));
            cIMInstance.setProperty("Name", new CIMValue((Object)"OS0"));
            cIMInstance.setProperty("Version", new CIMValue((Object)System.getProperty("os.version")));
            cIMInstance.setProperty("OSType", new CIMValue((Object)new UnsignedInt16(n)));
            cIMValue = new CIMObjectPath("CIM_OperatingSystem", "root/ibmhscS1_0");
            cIMValue.setKeys(cIMInstance.getKeyValuePairs());
            vector = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, (CIMObjectPath)cIMValue, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("CIM_RunningOS", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("Dependent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Antecedent", new CIMValue((Object)vector));
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("CIM_RunningOS", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance2);
            return string3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("177D");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private String createMemInst(String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
        try {
            CIMClass cIMClass = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_Memory", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance = cIMClass.newInstance();
            String string3 = string2;
            String string4 = null;
            if (this.mVpd.isVPDPresent()) {
                string3 = string3.concat("*SZ ");
                string4 = this.mVpd.getHSCTotalMemory();
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = this.getTotalMem();
                }
                string3 = string3.concat(string4);
                string3 = string3.concat("\n");
            } else {
                string3 = string3.concat("*SZ ");
                string4 = this.getTotalMem();
                string3 = string3.concat(string4);
                string3 = string3.concat("\n");
            }
            cIMInstance.setProperty("SystemCreationClassName", new CIMValue((Object)"IBMHSC_Console"));
            cIMInstance.setProperty("SystemName", new CIMValue((Object)string));
            cIMInstance.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Memory"));
            cIMInstance.setProperty("DeviceID", new CIMValue((Object)"MEM0"));
            if (string4 != null) {
                cIMInstance.setProperty("TotalMemory", new CIMValue((Object)new UnsignedInt32(Long.parseLong(string4))));
            }
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_Memory", "root/ibmhscS1_0");
            cIMObjectPath2.setKeys(cIMInstance.getKeyValuePairs());
            CIMObjectPath cIMObjectPath3 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath2, cIMInstance);
            CIMClass cIMClass2 = this.mProvCimomHandle.getClass(new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscS1_0"), false);
            CIMInstance cIMInstance2 = cIMClass2.newInstance();
            cIMInstance2.setProperty("GroupComponent", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("PartComponent", new CIMValue((Object)cIMObjectPath3));
            CIMObjectPath cIMObjectPath4 = new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscS1_0");
            cIMObjectPath4.setKeys(cIMInstance2.getKeyValuePairs());
            CIMObjectPath cIMObjectPath5 = CimomWrapper.createInstance((CIMOMHandle)this.mProvCimomHandle, cIMObjectPath4, cIMInstance2);
            return string3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            if (!(throwable instanceof HSCCIMException)) {
                throw new HSCCIMException("177E");
            }
            throw new HSCCIMException(throwable);
        }
    }

    private String getTotalMem() {
        try {
            String string;
            int n;
            String string2;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("free -bto");
            process.waitFor();
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            process.waitFor();
            process.destroy();
            bufferedReader.close();
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            StringTokenizer[] stringTokenizerArray = new StringTokenizer[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                stringTokenizerArray[n] = new StringTokenizer(stringArray[n], " \t\n");
            }
            n = 0;
            while (stringTokenizerArray[0].hasMoreTokens() && !(string = stringTokenizerArray[0].nextToken()).equalsIgnoreCase("total")) {
                ++n;
            }
            block5: for (int i = 1; i < stringTokenizerArray.length; ++i) {
                for (int j = 0; j <= n + 1; ++j) {
                    String string3 = stringTokenizerArray[i].nextToken();
                    if (j == 0 && !string3.equalsIgnoreCase("Mem:")) continue block5;
                    if (j != n + 1) continue;
                    return string3;
                }
            }
            return "0";
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            return "0";
        }
    }

    private String getHmcVersion() {
        try {
            EExecResult eExecResult = EExec.Exec((String)"/opt/hsc/bin/hsc version");
            String string = eExecResult.getStdout();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = 0;
            String string2 = "";
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (n == 1) {
                    string2 = string2 + "V" + string3;
                } else if (n == 3) {
                    string2 = string2 + "R" + string3;
                }
                ++n;
            }
            return string2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ConsoleClassLogInfo);
            return "R1V1.0";
        }
    }
}

